/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

/*Most of function has additional argument using as flags to
  decide which input should be overwritten:
	1st bit overwrite g_dstrXML string 
	2nd bit overwrite g_dstrXML size
	3rd bit overwrite g_dstrXMLNode string	
	4th bit overwrite g_dstrXMLNode size
	5th bit overwrite g_dstrXMLNodeData string
	6th bit overwrite g_dstrXMLNodeData size
	7th bit overwrite g_dstrXML with the resulted g_dstrXMLNode 
	8th bit overwrite g_dstrXML with the resulted g_dstrXMLNodeData 
*/

// #include <stdio.h>
//#include <stdlib.h>
// #include <string.h>
#include "drmxmlparser.h"
#include "tclib.h"
#include "tstutils.h"
#include "tOEMIMP.h"
#include "drmcrt.h"


static DRM_DWORD g_cbLicense=0;
static DRM_BYTE *g_pbLicense=NULL;
static DRM_CONST_STRING g_dstrXML = {0,0};
static DRM_CONST_STRING g_dstrXMLNodeData = {0,0};
static DRM_CONST_STRING g_dstrXMLNode = {0,0};
static DRM_ANSI_CONST_STRING g_dastrXML = {0,0};
static DRM_SUBSTRING g_dasstrNodeData  = {0,0};
static DRM_SUBSTRING g_dasstrNode      = {0,0};

/********************************/

DRM_RESULT TestXMLUtilGetXMLNode(long argc, char **argv);
DRM_RESULT TestXMLUtilGetXMLNodeAttribute(long argc, char **argv);
DRM_RESULT TestXMLUtilGetXMLSubNode(long argc, char **argv);
DRM_RESULT TestXMLUtilGetXMLNodeA(long argc, char **argv);
DRM_RESULT TestXMLUtilGetXMLNodeAttributeA(long argc, char **argv);
DRM_RESULT TestXMLUtilGetXMLSubNodeA(long argc, char **argv);
DRM_RESULT TestXMLUtilReinitialize(long iIndex, char **argv); 

 /*  Reinitialize all if iIndex=0*/
DRM_RESULT TestXMLUtilReinitialize(long iIndex, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
	if (argv!=NULL){
		iIndex=(int)OEM_atoi(argv[0]);
	}

 	if(iIndex==0 ||iIndex==1){ 
		DX_VOS_MemFree(g_pbLicense);
		g_pbLicense=NULL;
		g_dstrXML.pwszString=0;
		g_dastrXML.pszString=0;
  	}
 	if(iIndex==0 ||iIndex==2){ 
		g_cbLicense=0;
		g_dstrXML.cchString=0;
		g_dastrXML.cchString=0;
	}
	if(iIndex==0 ||iIndex==3){ 
 		g_dstrXMLNode.pwszString=0;
	}
 	if(iIndex==0 ||iIndex==4){ 
 		g_dstrXMLNode.cchString=0;
		g_dasstrNode.m_cch=0;
	}
	if(iIndex==0 ||iIndex==5){ 
 		g_dstrXMLNodeData.pwszString=0;
	}
 	if(iIndex==0 ||iIndex==6){ 
 		g_dstrXMLNodeData.pwszString=0;
	}
  
	return dr;
}

DRM_RESULT TestXMLUtilGetXMLNode(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long iOption=0;
	DRM_CONST_STRING szTag = {0,0};
	DRM_CONST_STRING szAttrName = {0,0};
	DRM_CONST_STRING szAttrValue = {0,0};
	DRM_WCHAR szArrayAttrName[256]={0};
	DRM_WCHAR szArrayAttrValue[256]={0};
	DRM_WCHAR szArrayXMLTag[256]={0};
	DRM_DWORD nthNode=0;
	int iXMLNullFlag=0, iNodeNullFlag=0, iNodeDataNullFlag=0;

 	/*at least 14 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<14){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLNode: error in number of arguments.");
        ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[5])  ||
	   !IsDigitalOnlyString(argv[7])||!IsDigitalOnlyString(argv[8])||!IsDigitalOnlyString(argv[10]) ||
	   !IsDigitalOnlyString(argv[12])||!IsDigitalOnlyString(argv[13])){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLNode: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
  
 	iOption=(long)OEM_atol(argv[13]);
	/*the 1st bit is to overwrite szxml*/ 
	if(iOption&1){
		TestXMLUtilReinitialize(1,NULL);
		if(argv[0]){
 			if(!(*argv[0])){
				g_cbLicense=1;
				ChkMem(g_pbLicense=(DRM_BYTE*)DX_VOS_MemMalloc(g_cbLicense*sizeof(DRM_WCHAR)));
				g_pbLicense[0] = 0;
			} else {
	 			/*load license from a file. The file name is given by argv[0]*/ 
                //D:\PRJ\wmdrm_dx\OUTPUT\TEST_DATA\xmlparser\xml 
				ChkArg(LoadTestFile("xml", argv[0], &g_pbLicense, &g_cbLicense));
			}	
			g_dstrXML.pwszString=(DRM_WCHAR*)g_pbLicense;
			g_dstrXML.cchString=g_cbLicense>>1;
		}
		else
			iXMLNullFlag=1;
   	}
 	/*the 2nd bit is to overwrite szxml size*/ 
	if(iOption&2){
		g_dstrXML.cchString=(DRM_DWORD)OEM_atol(argv[1]);
   	}
	if(argv[2]!=NULL){
 		OEM_mbstowcs(szArrayXMLTag, argv[2], DX_VOS_StrLen(argv[2])+1);
		szTag.pwszString=szArrayXMLTag;
	}
	else{
		szTag.pwszString=NULL;
	}
    szTag.cchString=(DRM_DWORD)OEM_atol(argv[3]);
	if(argv[4]!=NULL){
 		OEM_mbstowcs(szArrayAttrName, argv[4], DX_VOS_StrLen(argv[4])+1);
		szAttrName.pwszString=szArrayAttrName;
	}
	else{
		szAttrName.pwszString=NULL;
	}
	szAttrName.cchString=(DRM_DWORD)OEM_atol(argv[5]);
	if(argv[6]!=NULL){
 		OEM_mbstowcs(szArrayAttrValue, argv[6], DX_VOS_StrLen(argv[6])+1);
		szAttrValue.pwszString=szArrayAttrValue;
	}
	else{
		szAttrValue.pwszString=NULL;
	}
	szAttrValue.cchString=(DRM_DWORD)OEM_atol(argv[7]);
	nthNode=(DRM_DWORD)OEM_atol(argv[8]);
	if(iOption&8)
		g_dstrXMLNode.cchString=(DRM_DWORD)OEM_atol(argv[10]);
	if(iOption&32)
		g_dstrXMLNodeData.cchString=(DRM_DWORD)OEM_atol(argv[12]);
	if(argv[9]==NULL)
		iNodeNullFlag=1;
	if(argv[11]==NULL)
		iNodeDataNullFlag=1;
	/*overwrite g_dstrXML with the resulted g_dstrXMLNode or g_dstrXMLNodeData*/
	if(iOption&64){
		g_dstrXML.pwszString=g_dstrXMLNode.pwszString;
		g_dstrXML.cchString=g_dstrXMLNode.cchString;
	}
	if(iOption&128){
		g_dstrXML.pwszString=g_dstrXMLNodeData.pwszString;
		g_dstrXML.cchString=g_dstrXMLNodeData.cchString;
	}
	ChkDR(DRM_XML_GetNode(iXMLNullFlag>0?NULL:&g_dstrXML,&szTag,&szAttrName,&szAttrValue,nthNode,iNodeNullFlag>0?NULL:&g_dstrXMLNode,iNodeDataNullFlag>0?NULL:&g_dstrXMLNodeData));
  
ErrorExit:
  	return dr;
}

DRM_RESULT TestXMLUtilGetXMLSubNode(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long iOption=0;
	DRM_CONST_STRING szTag = {0,0};
	DRM_CONST_STRING szAttrName = {0,0};
	DRM_CONST_STRING szAttrValue = {0,0};
	DRM_WCHAR szArrayAttrName[256]={0};
	DRM_WCHAR szArrayAttrValue[256]={0};
	DRM_WCHAR szArrayXMLTag[256]={0};
	DRM_DWORD nthNode=0, nAtNthLayer=0;

	/*at least 15 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<15){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLSubNode: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[5])  ||
	   !IsDigitalOnlyString(argv[7])||!IsDigitalOnlyString(argv[8])||!IsDigitalOnlyString(argv[10]) ||
	   !IsDigitalOnlyString(argv[12])||!IsDigitalOnlyString(argv[13])||!IsDigitalOnlyString(argv[14])){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLSubNode: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
  
 	iOption=(long)OEM_atol(argv[14]);
	/*the 1st bit is to overwrite szxml*/ 
	if(iOption&1){
		TestXMLUtilReinitialize(1,NULL);
		if(argv[0]!=NULL){
 			if(!(*argv[0])){
				g_cbLicense=1;
				ChkMem(g_pbLicense=(DRM_BYTE*)DX_VOS_MemMalloc(g_cbLicense*sizeof(DRM_WCHAR)));
				g_pbLicense[0] = 0;
			} else {
	 			/*load license from a file. The file name is given by argv[0]*/ 
				ChkArg(LoadTestFile("xml", argv[0], &g_pbLicense, &g_cbLicense));
			}
			g_dstrXML.pwszString=(DRM_WCHAR*)g_pbLicense;
			g_dstrXML.cchString=g_cbLicense>>1;
		}
   	}
 	/*the 2nd bit is to overwrite szxml size*/ 
	if(iOption&2){
		g_dstrXML.cchString=(DRM_DWORD)OEM_atol(argv[1]);
   	}
	if(argv[2]!=NULL){
 		OEM_mbstowcs(szArrayXMLTag, argv[2], DX_VOS_StrLen(argv[2])+1);
		szTag.pwszString=szArrayXMLTag;
	}
	else{
		szTag.pwszString=NULL;
	}
    szTag.cchString=(DRM_DWORD)OEM_atol(argv[3]);
	if(argv[4]!=NULL){
 		OEM_mbstowcs(szArrayAttrName, argv[4], DX_VOS_StrLen(argv[4])+1);
		szAttrName.pwszString=szArrayAttrName;
	}
	else{
		szAttrName.pwszString=NULL;
	}
	szAttrName.cchString=(DRM_DWORD)OEM_atol(argv[5]);
	if(argv[6]!=NULL){
 		OEM_mbstowcs(szArrayAttrValue, argv[6], DX_VOS_StrLen(argv[6])+1);
		szAttrValue.pwszString=szArrayAttrValue;
	}
	else{
		szAttrValue.pwszString=NULL;
	}
	szAttrValue.cchString=(DRM_DWORD)OEM_atol(argv[7]);
	nthNode=(DRM_DWORD)OEM_atol(argv[8]);
	if(iOption&4)
		g_dstrXMLNode.cchString=(DRM_DWORD)OEM_atol(argv[10]);
	if(iOption&8)
		g_dstrXMLNodeData.cchString=(DRM_DWORD)OEM_atol(argv[12]);
	nAtNthLayer=(DRM_DWORD)OEM_atol(argv[13]);

	/*overwrite g_dstrXML with the resulted g_dstrXMLNode or g_dstrXMLNodeData*/
	if(iOption&64){
		g_dstrXML.pwszString=g_dstrXMLNode.pwszString;
		g_dstrXML.cchString=g_dstrXMLNode.cchString;
	}
	if(iOption&128){
		g_dstrXML.pwszString=g_dstrXMLNodeData.pwszString;
		g_dstrXML.cchString=g_dstrXMLNodeData.cchString;
	}
	ChkDR(DRM_XML_GetSubNode(&g_dstrXML,&szTag,&szAttrName,&szAttrValue,nthNode,&g_dstrXMLNode,&g_dstrXMLNodeData, nAtNthLayer));
 
ErrorExit:
  	return dr;
}

DRM_RESULT TestXMLUtilGetXMLNodeAttribute(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long iOption=0;
	DRM_CONST_STRING szAttrName = {0,0};
	DRM_CONST_STRING szAttrValue = {0,0};
	DRM_WCHAR szArrayAttrName[256]={0};
	DRM_WCHAR szArrayAttrValue[256]={0};
	DRM_WCHAR szVerifyArrayAttrValue[256]={0};
	DRM_WCHAR szArrayXMLNode[256]={0}; 
	int iNodeNullFlag=0,iAttrNameNullFlag=0;

  	/*at least 8 arguments. The last one is used to decide whether we need to overwrite the context*/
	/*7th argument to verify the value content*/
	if(argc<8){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLNodeAttribute: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[5])||
		!IsDigitalOnlyString(argv[7])){ 
	  	Log("Trace", "\t\tFrom TestXMLUtilGetXMLNodeAttribute: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
  
 	iOption=(long)OEM_atol(argv[7]);
	/*the 3rd bit is to overwrite g_dstrXMLNode*/ 
	if(iOption&4){
		TestXMLUtilReinitialize(3,NULL);
		if(argv[0]!=NULL){
			if(DX_VOS_StrCmp(argv[0], "nullstring")){
  	  			OEM_mbstowcs(szArrayXMLNode, argv[0], DX_VOS_StrLen(argv[0])+1);
	 			g_dstrXMLNode.pwszString=szArrayXMLNode;
				g_dstrXMLNode.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLNode);
			}
 		}
		else
			iNodeNullFlag=1;
   	}
 	/*the 4th bit is to overwrite g_dstrXMLNode size*/ 
	if(iOption&8){
		g_dstrXMLNode.cchString=(DRM_DWORD)OEM_atol(argv[1]);
   	}
	if(argv[2]!=NULL){
		if(DX_VOS_StrCmp(argv[2], "nullstring")){ 
			OEM_mbstowcs(szArrayAttrName, argv[2], DX_VOS_StrLen(argv[2])+1);
			szAttrName.pwszString=szArrayAttrName;
		}
	}
	else{
		iAttrNameNullFlag=1; 
	}
	szAttrName.cchString=(DRM_DWORD)OEM_atol(argv[3]);
	if(argv[4]!=NULL){
 		OEM_mbstowcs(szArrayAttrValue, argv[4], DX_VOS_StrLen(argv[4])+1);
		szAttrValue.pwszString=szArrayAttrValue;
	}
	else{
		szAttrValue.pwszString=0;
	}
	szAttrValue.cchString=(DRM_DWORD)OEM_atol(argv[5]);
 
	ChkDR(DRM_XML_GetNodeAttribute(iNodeNullFlag>0?NULL:&g_dstrXMLNode,iAttrNameNullFlag>0?NULL:&szAttrName,&szAttrValue));
 
	/*verify the attribute value*/
	if(argv[6]!=NULL){
		OEM_mbstowcs(szVerifyArrayAttrValue, argv[6], DX_VOS_StrLen(argv[6])+1);
		if(DRM_wcsncmp(szVerifyArrayAttrValue,szAttrValue.pwszString,DRM_wcslen(szVerifyArrayAttrValue))){
			ChkDR(DRM_E_FAIL);
		}
	}

ErrorExit:
  	return dr;
}

DRM_RESULT TestXMLUtilGetXMLNodeA(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long iOption=0;
	DRM_ANSI_CONST_STRING szTag = {0,0};
	DRM_ANSI_CONST_STRING szAttrName = {0,0};
	DRM_ANSI_CONST_STRING szAttrValue = {0,0};
	DRM_CHAR szArrayAttrName[256]={0};
	DRM_CHAR szArrayAttrValue[256]={0};
	DRM_CHAR szArrayXMLTag[256]={0};
	DRM_SUBSTRING dasstr;
	DRM_DWORD nthNode=0;

 	/*at least 14 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<14){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLNode: error in number of arguments.");
        ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[5])  ||
	   !IsDigitalOnlyString(argv[7])||!IsDigitalOnlyString(argv[8])||!IsDigitalOnlyString(argv[10]) ||
	   !IsDigitalOnlyString(argv[12])||!IsDigitalOnlyString(argv[13])){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLNode: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}

 	iOption=(long)OEM_atol(argv[13]);

	/*the 1st bit is to overwrite szxml*/ 
	if(iOption&1){
		TestXMLUtilReinitialize(1,NULL);
		ChkArg(argv[0]);
		if(!(*argv[0])) {
			g_cbLicense=1;
			ChkMem(g_pbLicense=(DRM_BYTE*)DX_VOS_MemMalloc(g_cbLicense*sizeof(DRM_WCHAR)));
			g_pbLicense[0] = 0;
		} else {
 			/*load license from a file. The file name is given by argv[0]*/ 
			ChkArg(LoadTestFile("xml", argv[0], &g_pbLicense, &g_cbLicense));
		}

		g_dastrXML.pszString=(DRM_CHAR*)g_pbLicense;
		g_dastrXML.cchString=g_cbLicense;
   	}

 	/*the 2nd bit is to overwrite szxml size*/ 
	if(iOption&2){
		g_dastrXML.cchString=(DRM_DWORD)OEM_atol(argv[1]);
   	}

	if(argv[2]!=NULL){
 		DX_VOS_FastMemCpy(szArrayXMLTag, argv[2], DX_VOS_StrLen(argv[2])+1);
		szTag.pszString=szArrayXMLTag;
	}
	else{
		szTag.pszString=NULL;
	}
    szTag.cchString=(DRM_DWORD)OEM_atol(argv[3]);

	if(argv[4]!=NULL){
 		DX_VOS_FastMemCpy(szArrayAttrName, argv[4], DX_VOS_StrLen(argv[4])+1);
		szAttrName.pszString=szArrayAttrName;
	}
	else{
		szAttrName.pszString=NULL;
	}
	szAttrName.cchString=(DRM_DWORD)OEM_atol(argv[5]);

	if(argv[6]!=NULL){
 		DX_VOS_FastMemCpy(szArrayAttrValue, argv[6], DX_VOS_StrLen(argv[6])+1);
		szAttrValue.pszString=szArrayAttrValue;
	}
	else{
		szAttrValue.pszString=NULL;
	}
	szAttrValue.cchString=(DRM_DWORD)OEM_atol(argv[7]);

	nthNode=(DRM_DWORD)OEM_atol(argv[8]);

	dasstr.m_ich = 0;
    dasstr.m_cch = g_dastrXML.cchString;

	if(iOption&8)
		g_dasstrNode.m_cch=(DRM_DWORD)OEM_atol(argv[10]);
	if(iOption&32)
		g_dasstrNodeData.m_cch=(DRM_DWORD)OEM_atol(argv[12]);

	/*overwrite g_dstrXML with the resulted g_dstrXMLNode or g_dstrXMLNodeData*/
	if(iOption&64){
		dasstr.m_ich = g_dasstrNode.m_ich;
		dasstr.m_cch = g_dasstrNode.m_cch;
	} else if(iOption&128){
		dasstr.m_ich = g_dasstrNodeData.m_ich;
		dasstr.m_cch = g_dasstrNodeData.m_cch;
	}
    
	ChkDR(DRM_XML_GetNodeA(g_dastrXML.pszString, 
	                      &dasstr,
	                      &szTag,
	                      &szAttrName,
	                      &szAttrValue,
	                       nthNode,
						   argv[9]? &g_dasstrNode: NULL,
						   argv[11]? &g_dasstrNodeData: NULL));
  
ErrorExit:
  	return dr;
}

DRM_RESULT TestXMLUtilGetXMLSubNodeA(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long iOption=0;
	DRM_ANSI_CONST_STRING szTag = {0,0};
	DRM_ANSI_CONST_STRING szAttrName = {0,0};
	DRM_ANSI_CONST_STRING szAttrValue = {0,0};
	DRM_CHAR szArrayAttrName[256]={0};
	DRM_CHAR szArrayAttrValue[256]={0};
	DRM_CHAR szArrayXMLTag[256]={0};
	DRM_DWORD nthNode=0, nAtNthLayer=0;
	DRM_SUBSTRING sstrXML;

 	/*at least 15 arguments. The last one is used to decide whether we need to overwrite the context*/
	if(argc<15){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLSubNode: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[5])  ||
	   !IsDigitalOnlyString(argv[7])||!IsDigitalOnlyString(argv[8])||!IsDigitalOnlyString(argv[10]) ||
	   !IsDigitalOnlyString(argv[12])||!IsDigitalOnlyString(argv[13])||!IsDigitalOnlyString(argv[14])){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLSubNode: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
  
 	iOption=(long)OEM_atol(argv[14]);
	/*the 1st bit is to overwrite szxml*/ 
	if(iOption&1){
		TestXMLUtilReinitialize(1,NULL);
		if(argv[0]){
			if (!(*argv[0])) {
				g_cbLicense = 1;
				ChkMem(g_pbLicense=(DRM_BYTE*)DX_VOS_MemMalloc(g_cbLicense*sizeof(DRM_WCHAR)));
				g_pbLicense[0] = 0;
			} else {
				/*load license from a file. The file name is given by argv[0]*/ 
				ChkArg(LoadTestFile("xml", argv[0], &g_pbLicense, &g_cbLicense));
			}	
			g_dastrXML.pszString=(DRM_CHAR*)g_pbLicense;
			g_dastrXML.cchString=g_cbLicense;
		}
   	}

 	/*the 2nd bit is to overwrite szxml size*/ 
	if(iOption&2)
		g_dastrXML.cchString=(DRM_DWORD)OEM_atol(argv[1]);

	if(argv[2]!=NULL){
 		DX_VOS_FastMemCpy(szArrayXMLTag, argv[2], DX_VOS_StrLen(argv[2])+1);
		szTag.pszString=szArrayXMLTag;
	} else
		szTag.pszString=NULL;
    szTag.cchString=(DRM_DWORD)OEM_atol(argv[3]);
	
	if(argv[4]!=NULL){
 		DX_VOS_FastMemCpy(szArrayAttrName, argv[4], DX_VOS_StrLen(argv[4])+1);
		szAttrName.pszString=szArrayAttrName;
	} else
		szAttrName.pszString=NULL;
	szAttrName.cchString=(DRM_DWORD)OEM_atol(argv[5]);

	if(argv[6]!=NULL){
 		DX_VOS_FastMemCpy(szArrayAttrValue, argv[6], DX_VOS_StrLen(argv[6])+1);
		szAttrValue.pszString=szArrayAttrValue;
	} else
		szAttrValue.pszString=NULL;
	szAttrValue.cchString=(DRM_DWORD)OEM_atol(argv[7]);

	nthNode=(DRM_DWORD)OEM_atol(argv[8]);
	if(iOption&4)
		g_dasstrNode.m_cch=(DRM_DWORD)OEM_atol(argv[10]);
	if(iOption&8)
		g_dasstrNodeData.m_cch=(DRM_DWORD)OEM_atol(argv[12]);
	nAtNthLayer=(DRM_DWORD)OEM_atol(argv[13]);

	/*overwrite g_dstrXML with the resulted g_dstrXMLNode or g_dstrXMLNodeData*/
	if(iOption&64){
		g_dastrXML.pszString=(const DRM_CHAR*)(g_pbLicense + g_dasstrNode.m_ich);
		g_dastrXML.cchString=g_dasstrNode.m_cch;
	}
	if(iOption&128){
		g_dastrXML.pszString=(const DRM_CHAR*)(g_pbLicense + g_dasstrNodeData.m_ich);
		g_dastrXML.cchString=g_dasstrNodeData.m_cch;
	}

	sstrXML.m_ich = 0;
	sstrXML.m_cch = g_dastrXML.cchString;
	ChkDR(DRM_XML_GetSubNodeA(g_dastrXML.pszString, &sstrXML, &szTag, &szAttrName,&szAttrValue,nthNode,&g_dasstrNode,&g_dasstrNodeData, nAtNthLayer));
 
ErrorExit:
  	return dr;
}

DRM_RESULT TestXMLUtilGetXMLNodeAttributeA(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long iOption=0;
	DRM_ANSI_CONST_STRING szAttrName      = { 0, 0 };
	DRM_SUBSTRING szAttrValue     = { 0, 0 };
	DRM_CHAR szArrayAttrName        [256] = { 0 };
	DRM_CHAR szArrayXMLNode         [256] = { 0 }; 

  	/*at least 8 arguments. The last one is used to decide whether we need to overwrite the context*/
	/*7th argument to verify the value content*/
	if(argc<8){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLNodeAttribute: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[5])||
		!IsDigitalOnlyString(argv[7])){ 
	  	Log("Trace", "\t\tFrom TestXMLUtilGetXMLNodeAttribute: error in the argument.");
		ChkDR(DRM_E_FAIL);
 	}
  
 	iOption=(long)OEM_atol(argv[7]);
	/*the 3rd bit is to overwrite g_dstrXMLNode*/ 
	if(iOption&4){
		TestXMLUtilReinitialize(3,NULL);
		if(argv[0]){
			g_dastrXML.cchString = DX_VOS_StrLen(argv[0]);
			DX_VOS_StrNCopy(szArrayXMLNode,sizeof(szArrayXMLNode), argv[0]);
  	  		g_dastrXML.pszString = szArrayXMLNode;
 			g_dasstrNode.m_ich = 0;
			g_dasstrNode.m_cch = g_dastrXML.cchString;
 		}
   	}
 	/*the 4th bit is to overwrite g_dstrXMLNode size*/ 
	if(iOption&8){
		g_dasstrNode.m_cch=(DRM_DWORD)OEM_atol(argv[1]);
   	}
	if(argv[2]){
		DX_VOS_StrNCopy(szArrayAttrName,sizeof(szArrayAttrName), argv[2]);
		szAttrName.pszString=szArrayAttrName;
		szAttrName.cchString=(DRM_DWORD)OEM_atol(argv[3]);
	}
 
	ChkDR(DRM_XML_GetNodeAttributeA(argv[0]? g_dastrXML.pszString: NULL, 
	                                &g_dasstrNode,
									argv[2]? &szAttrName: NULL,
	                               &szAttrValue));
	/*verify the value content*/
	if(argv[6]){
		ChkArg(szAttrValue.m_cch == DX_VOS_StrLen(argv[6]));
		ChkArg(!DX_VOS_StrNCmp(argv[6], g_dastrXML.pszString + szAttrValue.m_ich, szAttrValue.m_cch));
	}
ErrorExit:
  	return dr;
}

DRM_RESULT TestXMLUtilGetXMLNodeCData(long argc, char **argv)
{
	DRM_RESULT dr=DRM_SUCCESS;
 	long iOption=0;
	DRM_CONST_STRING szCData = {0,0};
	DRM_WCHAR szArrayCData[256]={0};
	DRM_WCHAR szVerifyArrayCData[256]={0};
	DRM_WCHAR szArrayXMLNode[256]={0};
	int iNodeNullFlag=0;

 	/*at least 6 arguments. The last one is used to decide whether we need to overwrite the context*/
	/*the 5th is to verify the CData content*/
	if(argc<6){
		Log("Trace", "\t\tFrom TestXMLUtilGetXMLNodeCData: error in number of arguments.");
		ChkDR(DRM_E_FAIL);
 	}
	if(!IsDigitalOnlyString(argv[1])||!IsDigitalOnlyString(argv[3])||!IsDigitalOnlyString(argv[5])){ 
	  	Log("Trace", "\t\tFrom TestXMLUtilGetXMLNodeCData: error in the argument.");
		 ChkDR(DRM_E_FAIL);
	}
  
 	iOption=(long)OEM_atol(argv[5]);
	/*the 3rd bit is to overwrite g_dstrXMLNode*/ 
	if(iOption&4){
		TestXMLUtilReinitialize(3,NULL);
		if(argv[0]!=NULL){
			if(DX_VOS_StrCmp(argv[0], "nullstring")){
 	  			OEM_mbstowcs(szArrayXMLNode, argv[0], DX_VOS_StrLen(argv[0])+1);
	 			g_dstrXMLNode.pwszString=szArrayXMLNode;
				g_dstrXMLNode.cchString=(DRM_DWORD)DRM_wcslen(szArrayXMLNode);
			}
			else{
				g_dstrXMLNode.pwszString=NULL;
				g_dstrXMLNode.cchString=0;
			}
		}
		else
			iNodeNullFlag=1;
   	}
 	/*the 4th bit is to overwrite g_dstrXMLNode size*/ 
	if(iOption&8){
		g_dstrXMLNode.cchString=(DRM_DWORD)OEM_atol(argv[1]);
   	}
	if(argv[2]!=NULL){
 		OEM_mbstowcs(szArrayCData, argv[2], DX_VOS_StrLen(argv[2])+1);
		szCData.pwszString=szArrayCData;
	}
	else{
		szCData.pwszString=NULL;
	}
	szCData.cchString=(DRM_DWORD)OEM_atol(argv[3]);
	 
	ChkDR(DRM_XML_GetNodeCData(iNodeNullFlag>0?NULL:&g_dstrXMLNode,&szCData));
	/*verify the CData*/
	if(argv[4]!=NULL){
		OEM_mbstowcs(szVerifyArrayCData, argv[4], DX_VOS_StrLen(argv[4])+1);
		if(DRM_wcsncmp(szVerifyArrayCData,szCData.pwszString,DRM_wcslen(szVerifyArrayCData))){
			ChkDR(DRM_E_FAIL);
		}
	}
ErrorExit:
  	return dr;
}


/* Get the default implementations for WrapTestRun, PreTestCase and PostTestCase */
/*
IMPLEMENT_DEFAULT_PRETESTCASE_AND_POSTTESTCASE
IMPLEMENT_DEFAULT_WARPTEST

BEGIN_APIMAP(testxmlparser_ansi, "DailyTestXMLParser")
	API_ENTRY(TestXMLUtilGetXMLNode)
	API_ENTRY(TestXMLUtilGetXMLSubNode)
	API_ENTRY(TestXMLUtilGetXMLNodeAttribute)
	API_ENTRY(TestXMLUtilGetXMLNodeCData)
	API_ENTRY(TestXMLUtilGetXMLNodeA)
	API_ENTRY(TestXMLUtilGetXMLSubNodeA)
	API_ENTRY(TestXMLUtilGetXMLNodeAttributeA)
	API_ENTRY(TestXMLUtilReinitialize)
END_APIMAP
*/

